VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmLIVDemo 
   Caption         =   "Laser Diode L-I-V Sweep Test Demo"
   ClientHeight    =   8595
   ClientLeft      =   1065
   ClientTop       =   630
   ClientWidth     =   9915
   LinkTopic       =   "Form1"
   ScaleHeight     =   8595
   ScaleWidth      =   9915
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   840
      Top             =   240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame Frame4 
      Caption         =   "Detector Bias Voltage and Current Range"
      Height          =   1095
      Left            =   6120
      TabIndex        =   36
      Top             =   7440
      Width           =   3615
      Begin VB.TextBox textN2CurrRange 
         Height          =   285
         Left            =   2760
         TabIndex        =   42
         Text            =   "0.002"
         Top             =   600
         Width           =   735
      End
      Begin VB.TextBox textN2Bias 
         Height          =   285
         Left            =   1920
         TabIndex        =   41
         Text            =   "0"
         Top             =   600
         Width           =   735
      End
      Begin VB.TextBox textN1CurrRange 
         Height          =   285
         Left            =   1080
         TabIndex        =   40
         Text            =   "0.002"
         Top             =   600
         Width           =   735
      End
      Begin VB.TextBox textN1Bias 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   0
         EndProperty
         Height          =   285
         Left            =   120
         TabIndex        =   37
         Text            =   "0"
         Top             =   600
         Width           =   855
      End
      Begin VB.Label Label19 
         Caption         =   "BD Curr."
         Height          =   255
         Left            =   2760
         TabIndex        =   44
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label18 
         Caption         =   "BD Bias V"
         Height          =   255
         Left            =   1920
         TabIndex        =   43
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label16 
         Caption         =   "FD Curr."
         Height          =   255
         Left            =   1080
         TabIndex        =   39
         Top             =   360
         Width           =   615
      End
      Begin VB.Label Label15 
         Caption         =   "FD Bias V"
         Height          =   255
         Left            =   240
         TabIndex        =   38
         Top             =   360
         Width           =   735
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Module Temperature Control:  2510 TEC SourceMeter"
      Height          =   1095
      Left            =   120
      TabIndex        =   29
      Top             =   7440
      Width           =   5775
      Begin VB.TextBox txtTECRes 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2760
         TabIndex        =   34
         Top             =   600
         Width           =   735
      End
      Begin VB.ComboBox comboTempOnOff 
         Height          =   315
         ItemData        =   "System LIV Sweep NI RevA01.frx":0000
         Left            =   4800
         List            =   "System LIV Sweep NI RevA01.frx":000A
         TabIndex        =   33
         Text            =   "OFF"
         Top             =   600
         Width           =   735
      End
      Begin VB.ComboBox comboTempSetPoint 
         Height          =   315
         ItemData        =   "System LIV Sweep NI RevA01.frx":0017
         Left            =   240
         List            =   "System LIV Sweep NI RevA01.frx":002A
         TabIndex        =   32
         Text            =   "25"
         Top             =   600
         Width           =   855
      End
      Begin VB.Label Label14 
         Caption         =   "TEC Resistance"
         Height          =   255
         Left            =   2520
         TabIndex        =   35
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label Label13 
         Caption         =   "Deg. Celsius"
         Height          =   255
         Left            =   1320
         TabIndex        =   31
         Top             =   600
         Width           =   1095
      End
      Begin VB.Label Label12 
         Caption         =   "Set Point"
         Height          =   255
         Left            =   240
         TabIndex        =   30
         Top             =   360
         Width           =   855
      End
   End
   Begin VB.OptionButton EnableTest 
      Caption         =   "Enable Pass/Fail"
      Height          =   255
      Left            =   6240
      TabIndex        =   28
      Top             =   6240
      Width           =   1575
   End
   Begin VB.TextBox textPassFail 
      Appearance      =   0  'Flat
      BackColor       =   &H0000FF00&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   24
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00008000&
      Height          =   555
      Left            =   6240
      TabIndex        =   27
      Text            =   "PASS"
      Top             =   6600
      Width           =   1575
   End
   Begin VB.Frame Frame2 
      Caption         =   "Laser Diode L-I-V Sweep Test Demo"
      Height          =   255
      Left            =   240
      TabIndex        =   18
      Top             =   1080
      Width           =   3495
   End
   Begin VB.Frame Frame1 
      Caption         =   "Test Statistics"
      Height          =   1335
      Left            =   120
      TabIndex        =   15
      Top             =   5880
      Width           =   5775
      Begin VB.TextBox textSteps 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   4560
         TabIndex        =   25
         Text            =   "100"
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textKinkStddev 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   3480
         TabIndex        =   23
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textKinkMinima 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   2400
         TabIndex        =   21
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textKinkMaxima 
         Alignment       =   1  'Right Justify
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   1320
         TabIndex        =   19
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox textThresoldCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   17
         Top             =   840
         Width           =   975
      End
      Begin VB.Label Label11 
         Alignment       =   2  'Center
         Caption         =   "Number of Steps"
         Height          =   495
         Left            =   4680
         TabIndex        =   26
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label10 
         Alignment       =   2  'Center
         Caption         =   "Kink Stddev"
         Height          =   375
         Left            =   3600
         TabIndex        =   24
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label9 
         Alignment       =   2  'Center
         Caption         =   "Kink Minima"
         Height          =   375
         Left            =   2520
         TabIndex        =   22
         Top             =   360
         Width           =   735
      End
      Begin VB.Label Label8 
         Alignment       =   2  'Center
         Caption         =   "Kink Maxima"
         Height          =   375
         Left            =   1440
         TabIndex        =   20
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "Threshold Current"
         Height          =   375
         Left            =   240
         TabIndex        =   16
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.Frame frameParameters 
      Caption         =   "L-I-V Sweep Test Parameters"
      Height          =   1215
      Left            =   4080
      TabIndex        =   4
      Top             =   120
      Width           =   5655
      Begin VB.TextBox textStepCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   4560
         TabIndex        =   14
         Text            =   "0.0001"
         Top             =   720
         Width           =   735
      End
      Begin VB.TextBox textStopCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   3480
         TabIndex        =   13
         Text            =   "0.008"
         Top             =   720
         Width           =   855
      End
      Begin VB.TextBox textStartCurrent 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2400
         TabIndex        =   12
         Text            =   "0.0005"
         Top             =   720
         Width           =   855
      End
      Begin VB.TextBox txtSourceDelay 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   1200
         TabIndex        =   8
         Text            =   "0.003"
         Top             =   720
         Width           =   975
      End
      Begin VB.ComboBox comboNPLC 
         Height          =   315
         ItemData        =   "System LIV Sweep NI RevA01.frx":0042
         Left            =   240
         List            =   "System LIV Sweep NI RevA01.frx":0065
         TabIndex        =   6
         Text            =   "1"
         Top             =   720
         Width           =   735
      End
      Begin VB.Label Label5 
         Alignment       =   2  'Center
         Caption         =   "Step Current (A)"
         Height          =   375
         Left            =   4560
         TabIndex        =   11
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label4 
         Alignment       =   2  'Center
         Caption         =   "Stop Current (A)"
         Height          =   375
         Left            =   3480
         TabIndex        =   10
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label3 
         Alignment       =   2  'Center
         Caption         =   "Start Current (A)"
         Height          =   495
         Left            =   2400
         TabIndex        =   9
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "Source Delay"
         Height          =   255
         Left            =   1200
         TabIndex        =   7
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         Caption         =   "NPLC"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   360
         Width           =   855
      End
   End
   Begin MSChart20Lib.MSChart MSChart1 
      Height          =   4695
      Left            =   120
      OleObjectBlob   =   "System LIV Sweep NI RevA01.frx":009D
      TabIndex        =   3
      Top             =   1320
      Width           =   9975
   End
   Begin VB.CommandButton buttonRunTest 
      Caption         =   "L-I-V Sweep Test"
      Height          =   375
      Left            =   8280
      TabIndex        =   2
      Top             =   6840
      Width           =   1455
   End
   Begin VB.TextBox textTime 
      Alignment       =   1  'Right Justify
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   8280
      TabIndex        =   0
      Top             =   6360
      Width           =   1455
   End
   Begin VB.Image Image1 
      Height          =   735
      Left            =   240
      Picture         =   "System LIV Sweep NI RevA01.frx":DDE8
      Top             =   120
      Width           =   3510
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Total Test Time"
      Height          =   255
      Left            =   8280
      TabIndex        =   1
      Top             =   6000
      Width           =   1455
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuSaveAs 
         Caption         =   "Save &As"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmLIVDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*******************************************************************
'***                                                             ***
'***             Laser Diode L-I-V Sweep Test Demo               ***
'***                                                             ***
'*******************************************************************
'
'This demo is intended to be an example of how to use a 2420 and two
'2400s to perform an L-I-V sweep test on a laser diode module.
'Modifications to this program may be required to test attain the
'required kink detection sensitivity.
'
'Note that very little error checking and no error handling is used
'in this program.  In a production environment, error checking and
'handling would be a must.
'This code was originally written for the CEC GPIB card (Keithley PN KPCI-488)
'The code was modified 12/12/00 to work with the National Instruments
'GPIB card.  The original code will remain inline, but commented out.
'Old code that was already commented out is "double" commented(='')
'The code for the 2510 TEC cooler was updated on 12/15/00

Option Explicit

Dim intStatus As Integer        'GPIB status
Dim intLength As Integer        'Length of GPIB input string
Dim intSteps As Integer         'Steps required given start, stop
                                'and step

Dim strData As String           'GPIB input string

Dim dblSourceDelay As Double    'Source Delay for 2420
Dim dblStartCurrent As Double   'Starting Current Sweep Level
Dim dblStopCurrent As Double    'Final Current Sweep Level
Dim dblStepCurrent As Double    'Current Step for Sweep

Dim dblArray(1 To 6, 1 To 1010) As Double   'dblArray holds all the raw
                                            'data and calculated test
                                            'results.  It also feed
                                            'the chart object.

Const intKth2420% = 24       '2420 is GPIB Address 24
Const intKth2500% = 25       '2500 is GPIB Address 25
Const intKth2510% = 10       '2510 is GPIB Address 10
Const intGPIB% = 0           'GPIB card 0 for NI code
Dim intDeviceArray%(2)       'Array of 2420, 2500 GPIB addresses, necessary for ResetSys NI call

Const intLDVoltage% = 1     'These constants are used to improve
Const intLDCurrent% = 2     'readability of the code by naming
Const intBSDCurrent% = 3    'each of the rows in dblArray.
Const intPDCurrent% = 4
Const int2ndDofPDC% = 5
Const int1stDofPDC% = 6

'******************************************************************
'Reset Instruments

'This subroutine resets all three instruments from a power on state
'or from almost any error condition.

'******************************************************************
Private Sub ResetInstruments()

textTime.ForeColor = &HFF0000   'set text color to green
textTime.Text = "Testing..."    'display 'Testing...' status

'NI code.  Set up array for the initialization of the LIV equipment (done in SetupXXXX routines)
'Note:  if 2510 was reset here, it could change the existing 2510 status
intDeviceArray(0) = intKth2420  'element is 2420 address
intDeviceArray(1) = intKth2500  'element is 2500 address
intDeviceArray(2) = NOADDR      'last element of addr array must be NOADDR, a NI-defined const

'Reset 2420

'***CEC code below***
'Call Send(intKth2420, "*rst", intStatus)                    'issue reset
'Call Send(intKth2420, ":trace:feed:cont never", intStatus)  'turn off trace
'Call Send(intKth2420, ":trace:clear", intStatus)            'clear trace buffer
'Call Send(intKth2420, "*cls", intStatus)                    'clear status register
'***CEC code above***

'NI code below
'Call Send(intGPIB, intKth2420, "*rst", NLend)                    'issue reset, NLend sends \n at EOI
'Maybe use ResetSys instead of *rst - ResetSys does IFC then DCL then *rst
Call ResetSys(intGPIB, intDeviceArray())        'Reset all equip - see Form Load for DeviceArray contents
Call Send(intGPIB, intKth2420, ":trace:feed:cont never", NLend)  'turn off trace
Call Send(intGPIB, intKth2420, ":trace:clear", NLend)            'clear trace buffer
Call Send(intGPIB, intKth2420, "*cls", NLend)                    'clear status register

'Reset 2500
'***CEC code below***
'Call Send(intKth2500, "*rst", intStatus)                   'issue reset
'Call Send(intKth2500, ":trace:feed:cont never", intStatus) 'turn off trace
'Call Send(intKth2500, ":trace:clear", intStatus)           'clear trace buffer
'Call Send(intKth2500, "*cls", intStatus)                   'clear status register
'***CEC code above***

'NI code below
'Call Send(intGPIB, intKth2500, "*rst", NLend)                   'issue reset, Not necessary because of ResetSys above
Call Send(intGPIB, intKth2500, ":trace:feed:cont never", NLend) 'turn off trace
Call Send(intGPIB, intKth2500, ":trace:clear", NLend)           'clear trace buffer
Call Send(intGPIB, intKth2500, "*cls", NLend)                   'clear status register


End Sub

'******************************************************************
'Setup first 2500

'Setup 2500 to measure the photodiode current through the front
'facet external photodiode and back facet internal photodiode.

'******************************************************************
Private Sub Setup2500()

' General instrument configuration
'***CEC code below***
'Call Send(intKth2500, ":form:elem curr1,curr2", intStatus)         'output only current readings
'Call Send(intKth2500, ":form:data sre;bord swap", intStatus)       'binary format
''Call send(intKth2500, ":syst:key 16", intStatus)                   ' toggle display to show both channels
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":form:elem curr1,curr2", NLend)         'output only current readings
Call Send(intGPIB, intKth2500, ":form:data sre;bord swap", NLend)       'binary format
Call Send(intGPIB, intKth2420, ":syst:azer off", NLend)         'disable auto zero for speed

'  Note that the third line of CEC code above was already commented out and is not translated into NI code

' *******   Configure Channel 1 of 2500   **********

' Setup sense circuitry for 20mA range
'***CEC code below***
'Call Send(intKth2500, ":sens1:curr:nplc " & comboNPLC, intStatus)   'set NPLC using input Param.
'Call Send(intKth2500, ":sens1:curr:rang " & textN1CurrRange, intStatus)       '20mA range
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":sens1:curr:nplc " & comboNPLC, NLend)   'set NPLC using input Param.
Call Send(intGPIB, intKth2500, ":sens1:curr:rang " & textN1CurrRange, NLend)       '20mA range

'Setup source to bias the front facet photodiode.
'***CEC code below***
'Call Send(intKth2500, ":sour1:volt:range 10", intStatus)      'set range to 10V
'If textN1Bias > 10 Then: textN1Bias = 10
'If textN1Bias < -10 Then: textN1Bias = -10
'Call Send(intKth2500, ":sour1:volt " & textN1Bias, intStatus) 'set bias output
'Call Send(intKth2500, ":sour1:delay 0", intStatus)     'set source delay to zero
'Call Send(intKth2500, ":sour1:gcon 1", intStatus)       'enable ground connect relay
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":sour1:volt:range 10", NLend)      'set range to 10V
If textN1Bias > 10 Then: textN1Bias = 10
If textN1Bias < -10 Then: textN1Bias = -10
Call Send(intGPIB, intKth2500, ":sour1:volt " & textN1Bias, NLend) 'set bias output
Call Send(intGPIB, intKth2500, ":sour1:delay 0", NLend)     'set source delay to zero
Call Send(intGPIB, intKth2500, ":sour1:gcon 1", NLend)       'enable ground connect relay


' *******   Configure Channel 2 of 2500   **********

' Setup sense circuitry for 20mA range

'***CEC code below***
'Call Send(intKth2500, ":sens2:curr:nplc " & comboNPLC, intStatus)   'set NPLC using input Param.
'Call Send(intKth2500, ":sens2:curr:rang " & textN2CurrRange, intStatus)       '20mA range
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":sens2:curr:nplc " & comboNPLC, NLend)   'set NPLC using input Param.
Call Send(intGPIB, intKth2500, ":sens2:curr:rang " & textN2CurrRange, NLend)       '20mA range

'Setup source to bias the photodiode with 5V.

'***CEC code below***
'Call Send(intKth2500, ":sour2:volt:range 10", intStatus)      'set range to 10V
'If textN2Bias > 10 Then: textN2Bias = 10
'If textN2Bias < -10 Then: textN2Bias = -10
'Call Send(intKth2500, ":sour2:volt " & textN2Bias, intStatus) 'set bias output
'Call Send(intKth2500, ":sour2:delay 0", intStatus)     'set source delay to zero
'Call Send(intKth2500, ":sour2:gcon 1", intStatus)       'enable ground connect relay
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":sour2:volt:range 10", NLend)      'set range to 10V
If textN2Bias > 10 Then: textN2Bias = 10                           'ensure -10<= bias => 10V
If textN2Bias < -10 Then: textN2Bias = -10
Call Send(intGPIB, intKth2500, ":sour2:volt " & textN2Bias, NLend) 'set bias output
Call Send(intGPIB, intKth2500, ":sour2:delay 0", NLend)     'set source delay to zero
Call Send(intGPIB, intKth2500, ":sour2:gcon 1", NLend)       'enable ground connect relay


'Setup Trigger Model:  Bypass both arm layers and use trigger
'layer to synch with trigger from 2420.

'***CEC code below***
'Call Send(intKth2500, ":arm:sour imm", intStatus)             'bypass arm layer 1
'Call Send(intKth2500, ":arm:coun 1", intStatus)               'set scan count
'Call Send(intKth2500, ":arm:dir acc", intStatus)              'wait for trigger event
'Call Send(intKth2500, ":trig:clear", intStatus)               'clear triggers
'Call Send(intKth2500, ":trig:sour tlink", intStatus)          'use trigger link
'Call Send(intKth2500, ":trig:ilin 2", intStatus)              'input trigger on line 2
'Call Send(intKth2500, ":trig:olin 1", intStatus)              'output trigger on line 1
'Call Send(intKth2500, ":trig:input sense", intStatus)         'wait for input trigger before
'Call Send(intKth2500, ":trig:outp sense", intStatus)          'output trigger after setting
'Call Send(intKth2500, ":trig:dir acceptor", intStatus)        'do not bypass on first pass
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":arm:sour imm", NLend)             'bypass arm layer 1
Call Send(intGPIB, intKth2500, ":arm:coun 1", NLend)               'set scan count
Call Send(intGPIB, intKth2500, ":arm:dir acc", NLend)              'wait for trigger event
Call Send(intGPIB, intKth2500, ":trig:clear", NLend)               'clear triggers
Call Send(intGPIB, intKth2500, ":trig:sour tlink", NLend)          'use trigger link
Call Send(intGPIB, intKth2500, ":trig:ilin 2", NLend)              'input trigger on line 2
Call Send(intGPIB, intKth2500, ":trig:olin 1", NLend)              'output trigger on line 1
Call Send(intGPIB, intKth2500, ":trig:input sense", NLend)         'wait for input trigger before
Call Send(intGPIB, intKth2500, ":trig:outp sense", NLend)          'output trigger after setting
Call Send(intGPIB, intKth2500, ":trig:dir acceptor", NLend)        'do not bypass on first pass


''Call send(intKth2500, ":trac:feed calc3,calc4", intStatus)

'NI-only code to open and initialize a device descriptor for
'the 2500, this device descriptor is required for low-level (ib* commands)
'control/communication, which is replace by high level ResetSys command
'int2500Desc = ildev(intGPIB, intKth2420, 0, T10s, 1, 0)     'get device descriptor for 2500, using 10 sec timeout



End Sub



'******************************************************************
'Setup 2420

'The 2420 will be setup to sweep from start (lower level) to stop
'(higher level) current in steps defined by the sweep parameters.
'The parameters be checked before Setup2420 is called.

'The 2420 also masters the trigger link for the sweep.

'******************************************************************
Private Sub Setup2420()

'Setup SourceMeter(tm) system commands:

'***CEC code below***
'Call Send(intKth2420, ":syst:beep:stat off", intStatus)         'disable beeper
'Call Send(intKth2420, ":syst:azer:stat off", intStatus)         'disable auto zero for speed
'Call Send(intKth2420, ":syst:rsen 1", intStatus)                'enable four-wire measurements
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2420, ":syst:beep:stat off", NLend)         'disable beeper
Call Send(intGPIB, intKth2420, ":syst:azer:stat off", NLend)         'disable auto zero for speed
Call Send(intGPIB, intKth2420, ":syst:rsen 1", NLend)                'enable four-wire measurements


''Call send(intKth2420, ":display:enable off", intStatus)        'disable display

'***CEC code below***
'Call Send(intKth2420, ":rout:term rear", intStatus)             'use rear terminals
'***CEC code above***

'NI code below
'Call Send(intGPIB, intKth2420, ":rout:term rear", NLend)             'use rear terminals

'The source is configured for the sweep from textStartCurrent to textStopCurrent
'in steps defined by textStepCurrent.  The sweep will use the best fixed range
'to prevent the inherent dicontinuities of range changing from being seen by the
'analysis code as kink.  The source delay is also set to accomidate the cable and
'DUT capacitive loading.

'***CEC code below***
'Call Send(intKth2420, ":sour:func curr", intStatus)                     'source current
'Call Send(intKth2420, ":sour:curr:start " & textStartCurrent, intStatus) 'set start (min.)
'Call Send(intKth2420, ":sour:curr:stop " & textStopCurrent, intStatus)  'set stop (max.)
'Call Send(intKth2420, ":sour:curr:step " & textStepCurrent, intStatus)  'set step
'Call Send(intKth2420, ":sour:curr:mode sweep", intStatus)               'enable sweep mode
'Call Send(intKth2420, ":sour:swe:rang best", intStatus)                 'use best fixed range
'Call Send(intKth2420, ":sour:swe:spac lin", intStatus)                  'select linear sweep
'Call Send(intKth2420, ":sour:del " & txtSourceDelay, intStatus)        'set source delay
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2420, ":sour:func curr", NLend)                     'source current
Call Send(intGPIB, intKth2420, ":sour:curr:start " & textStartCurrent, NLend) 'set start (min.)
Call Send(intGPIB, intKth2420, ":sour:curr:stop " & textStopCurrent, NLend)  'set stop (max.)
Call Send(intGPIB, intKth2420, ":sour:curr:step " & textStepCurrent, NLend)  'set step
Call Send(intGPIB, intKth2420, ":sour:curr:mode sweep", NLend)               'enable sweep mode
Call Send(intGPIB, intKth2420, ":sour:swe:rang best", NLend)                 'use best fixed range
Call Send(intGPIB, intKth2420, ":sour:swe:spac lin", NLend)                  'select linear sweep
Call Send(intGPIB, intKth2420, ":sour:del " & txtSourceDelay, NLend)        'set source delay


'The 2420 will source current and measure the forward junction voltage
'across the laser diode.  Both current and voltage will be passed to
'the analysis portion of the code.
'***CEC code below***
'Call Send(intKth2420, ":sens:volt:nplc " & comboNPLC, intStatus) 'set NPLC per input param.
'Call Send(intKth2420, ":sens:func:conc off", intStatus)          'turn off concurrent meas.
'Call Send(intKth2420, ":sens:func 'volt'", intStatus)            'sense voltage (V forward of LD)
'Call Send(intKth2420, ":sens:volt:prot 5", intStatus)            'limit output voltage to 5V
'Call Send(intKth2420, ":sens:volt:range 20", intStatus)
'
'Call Send(intKth2420, ":form:elem volt,curr", intStatus)         'readback both voltage and current
'
'Call Send(intKth2420, ":format:data sre;bord swap", intStatus)   'binary format
'
'Call Send(intKth2420, ":stat:meas:enab 512", intStatus)         'mask "buffer full" byte
'Call Send(intKth2420, "*sre 1", intStatus)                      'mask "measurement summary bit" for SRQ
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2420, ":sens:volt:nplc " & comboNPLC, NLend) 'set NPLC per input param.
Call Send(intGPIB, intKth2420, ":sens:func:conc off", NLend)          'turn off concurrent meas.
Call Send(intGPIB, intKth2420, ":sens:func 'volt'", NLend)            'sense voltage (V forward of LD)
Call Send(intGPIB, intKth2420, ":sens:volt:prot 5", NLend)            'limit output voltage to 5V
Call Send(intGPIB, intKth2420, ":sens:volt:range 5", NLend)          'set Voltage Range to 20V

Call Send(intGPIB, intKth2420, ":form:elem volt,curr", NLend)         'readback both voltage and current

Call Send(intGPIB, intKth2420, ":format:data sre;bord swap", NLend)   'binary format

Call Send(intGPIB, intKth2420, ":stat:meas:enab 512", NLend)         'mask "buffer full" byte
Call Send(intGPIB, intKth2420, "*sre 1", NLend)                      'mask "measurement summary bit" for SRQ


'Trigger layer is used to keep track of triggers from the front facet
'photodetector meter.  The trigger count will be set later.
'***CEC code below***
'Call Send(intKth2420, ":arm:sour imm", intStatus)              'bypass arm layer
'Call Send(intKth2420, ":arm:count inf", intStatus)
'
'Call Send(intKth2420, ":trig:clear", intStatus)                 'clear triggers
'Call Send(intKth2420, ":trig:sour tlink", intStatus)            'use trigger link
'Call Send(intKth2420, ":trig:ilin 1", intStatus)                'input trigger on line 1
'Call Send(intKth2420, ":trig:olin 2", intStatus)                'output trigger on line 2
'Call Send(intKth2420, ":trig:input source", intStatus)          'wait for input trigger before
'                                                                'changing source
'Call Send(intKth2420, ":trig:outp del", intStatus)              'output trigger after soaking device
'                                                                'new source current value
'Call Send(intKth2420, ":trig:dir source", intStatus)            'bypass first input trigger
'Call Send(intKth2420, ":trig:delay 0", intStatus)               'set trigger delay to 0mS
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2420, ":arm:sour imm", NLend)              'bypass arm layer
Call Send(intGPIB, intKth2420, ":arm:count inf", NLend)

Call Send(intGPIB, intKth2420, ":trig:clear", NLend)                 'clear triggers
Call Send(intGPIB, intKth2420, ":trig:sour tlink", NLend)            'use trigger link
Call Send(intGPIB, intKth2420, ":trig:ilin 1", NLend)                'input trigger on line 1
Call Send(intGPIB, intKth2420, ":trig:olin 2", NLend)                'output trigger on line 2
Call Send(intGPIB, intKth2420, ":trig:input source", NLend)          'wait for input trigger before
                                                                'changing source
Call Send(intGPIB, intKth2420, ":trig:outp del", NLend)              'output trigger after soaking device
                                                                'new source current value
Call Send(intGPIB, intKth2420, ":trig:dir source", NLend)            'bypass first input trigger
Call Send(intGPIB, intKth2420, ":trig:delay 0", NLend)               'set trigger delay to 0mS

'NI-only code to open and initialize a device descriptor for
'the 2420, this device descriptor is required for low-level (ib* commands)
'control/communication, which is replace by high level ResetSys command
'int2420Desc = ildev(intGPIB, intKth2420, 0, T10s, 1, 0)     'get device descriptor for 2420, using 10 sec timeout



End Sub

'******************************************************************
'ExecuteSweep:

'

'******************************************************************
Private Sub ExecuteSweep()

Dim poll As Integer
Dim longTempTime As Long
Dim longTempTime2 As Long
Dim intPointer As Integer
Dim intMaxPoint As Integer
Dim intMinPoint As Integer
Dim intStrPointer As Integer
Dim dblMaxima As Double
Dim dblMinima As Double
Dim dblSum As Double
Dim dblMean As Double
Dim dblStddev As Double
Dim byteArray!(1 To 5000)
Dim status&, length&
Dim int2420Talk As Integer                          'for NI MTA command
Dim int2500Talk As Integer                          'for NI MTA command
Dim intResult As Integer

'Begin sweep by setting up trigger counts, trace length, and
'enabling the trace subsystems.
    
longTempTime = Timer    'grab a time stamp before starting test
    
'***CEC code below***
'Call Send(intKth2500, ":trig:count " & textSteps, intStatus)  'set trigger count
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":trig:count " & textSteps, NLend)  'set trigger count

' Note:  "double" commented code below was already commented out before NI translation
''Call send(intKth2500, ":trace:feed:cont never", intStatus)    'turn off trace control
''Call send(intKth2500, ":trace:cle", intStatus)                'clear trace logic
''Call send(intKth2500, ":trace:poin " & textSteps, intStatus)  'set number of measurments to record
''Call send(intKth2500, ":trace:feed sens", intStatus)          'feed trace memory with measurments
''Call send(intKth2500, ":trace:feed:cont next", intStatus)     'enable trace logic for recording
    
'***CEC code below***
'Call Send(intKth2420, "*cls", intStatus)                        'clear all registers
'Call Send(intKth2420, ":arm:count 1", intStatus)                'set arm count to 1
'Call Send(intKth2420, ":trig:count " & textSteps, intStatus)    'set trigger count
'Call Send(intKth2420, ":trace:feed:cont never", intStatus)      'disable trace logic
'Call Send(intKth2420, ":trace:clear", intStatus)                'clear trace logic
'Call Send(intKth2420, ":trace:points " & textSteps, intStatus)  'set number of measurments to record
'Call Send(intKth2420, ":trace:feed sens", intStatus)            'feed trace memory with measurments
'Call Send(intKth2420, ":trace:feed:control next", intStatus)    'enable trace logic
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2420, "*cls", NLend)                        'clear all registers
Call Send(intGPIB, intKth2420, ":arm:count 1", NLend)                'set arm count to 1
Call Send(intGPIB, intKth2420, ":trig:count " & textSteps, NLend)    'set trigger count
Call Send(intGPIB, intKth2420, ":trace:feed:cont never", NLend)      'disable trace logic
Call Send(intGPIB, intKth2420, ":trace:clear", NLend)                'clear trace logic
Call Send(intGPIB, intKth2420, ":trace:points " & textSteps, NLend)  'set number of measurments to record
Call Send(intGPIB, intKth2420, ":trace:feed sens", NLend)            'feed trace memory with measurments
Call Send(intGPIB, intKth2420, ":trace:feed:control next", NLend)    'enable trace logic


'Turn outputs on, take units out of idle state, trigger sweep, wait
'for completion, and issue trace data queries:

'clear comments for dual 2400n configuration
'***CEC code below***
'Call Send(intKth2500, ":outp1:stat on", intStatus)    'turn on front facet diode bias
'Call Send(intKth2500, ":outp2:stat on", intStatus)    'turn on back facet diode bias
'Call Send(intKth2420, ":outp:stat on", intStatus)     'turn on LD drive output
'Call Send(intKth2500, ":init", intStatus)             'take front facet meter out of idle
'Call Send(intKth2420, ":init", intStatus)               'trigger the sweep...
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2500, ":outp1:stat on", NLend)    'turn on front facet diode bias
Call Send(intGPIB, intKth2500, ":outp2:stat on", NLend)    'turn on back facet diode bias
Call Send(intGPIB, intKth2420, ":outp:stat on", NLend)     'turn on LD drive output
Call Send(intGPIB, intKth2500, ":init", NLend)             'take front facet meter out of idle
Call Send(intGPIB, intKth2420, ":init", NLend)               'trigger the sweep...
   
Do
    DoEvents        'the 2420 will issue an srq once the buffer is full and testing complete
    Call TestSRQ(intGPIB, intResult)                           'check status of SRQ line: non-zero if line is asserted, zero=not asserted
Loop Until intResult
'Loop Until poll
'***CEC code below***
'Call spoll(intKth2420, poll, intStatus)
'NI Code below
Call ReadStatusByte(intGPIB, intKth2420, poll)          'clear SRQ status byte (clears SRQ annunciator)

textTime.Text = (Timer - longTempTime) & " Seconds"             'calculate elapse time

'***CEC code below***
'Call Send(intKth2420, ":outp:stat off", intStatus)          'turn off 2420
'Call Send(intKth2500, ":outp1:stat off", intStatus)         'turn off front facet bias
'Call Send(intKth2500, ":outp2:stat off", intStatus)         'turn off back facet bias
'
'Call Send(intKth2420, ":trace:data?", intStatus)       'query 2420 to empty buffer
'Call Send(intKth2500, ":fetch?", intStatus)            'query PD meter for latest readings
'***CEC code above***

'NI code below
Call Send(intGPIB, intKth2420, ":outp:stat off", NLend)          'turn off 2420
Call Send(intGPIB, intKth2500, ":outp1:stat off", NLend)         'turn off front facet bias
Call Send(intGPIB, intKth2500, ":outp2:stat off", NLend)         'turn off back facet bias

Call Send(intGPIB, intKth2420, ":trace:data?", NLend)       'query 2420 to empty buffer
Call Send(intGPIB, intKth2500, ":fetch?", NLend)            'query PD meter for latest readings
  
    
'Enter laser diode voltage and current trace and pass to dblArray().
'Note that the 2420 is read first because it prepares the output table
'faster than the 2500.  In this way, the 2500 have more time to
'perpare the output table before the code attempts to read the trace
'buffer.
    
'***CEC code below***
'Call transmit("UNT UNL MLA TALK" + Str$(intKth2420), intStatus)   ' Address 2400 to talk
'If (intStatus And 8) Then Stop                                    ' Check for timeout
'Call IErarray(byteArray!(1), 2, length, status)                   ' Read "#0" from binary string
'If (intStatus And 8) Then Stop                                    ' Check for timeout
'Call IErarray(byteArray!(1), 2 * intSteps * 4 + 1, length, status) ' Enter rdgs
'If (intStatus And 8) Then Stop                                    ' Check for timeout
'If length& < 2 * intSteps * 4 Then Stop                           ' Verify length of string
'Call transmit("UNT UNL", intStatus)                               ' Stop talking
'If (intStatus And 8) Then Stop                                    ' Check for timeout
'***CEC code above***

'NI code below
'int2420Talk = intKth2420 + 64                                   'Calculate ascii character# for NI MTA code, where MTA0=64=@
'Below low level commands are replaced by ReceiveSetup
'Call ibcmd(intGPIB, "_?" + Chr(int2420Talk))                 ' Address 2400 to talk
'status = ilcmd(intGPIB, "_?" + " " + Chr(int2420Talk))        ' Address 2400 to talk, _=UNT, ?=UNL, " "=MLA0
'Above low level commands are replaced by ReceiveSetup
Call ReceiveSetup(intGPIB, intKth2420)                'Set up 2420 to talk, GPIB board is listening
If (status > 16383) Then Stop                                  'Check for timeout(=16384)
Call RcvRespMsg32(intGPIB, byteArray(1), 2, STOPend)
If (status > 16383) Then Stop                                  'Check for timeout(=16384)
Call RcvRespMsg32(intGPIB, byteArray(1), 2 * intSteps * 4 + 1, STOPend) 'receive readings from 2420, automatically grabbing all data, ibcntl for # of bytes
If (status > 16383) Then Stop                                  'Check for timeout(=16384)
If ibcntl < 2 * intSteps * 4 Then Stop                           ' Verify length of string using global ibcntl, 2 arrays (V, I), 4 8-bit bytes each reading
Call SendIFC(intGPIB)                                             'stop talking by sending InterFaceClear (IFC) command
If (status > 16383) Then Stop                                  'Check for timeout(=16384)

For intPointer = 1 To intSteps                                         'loop once for each step
    dblArray(intLDVoltage, intPointer) = byteArray(intPointer * 2 - 1) 'pass voltage value to dblArray()
    dblArray(intLDCurrent, intPointer) = byteArray(intPointer * 2)     'pass current value to dblArray()
Next intPointer


' Enter front facet current (channel 1) and back facet (channel 2) trace and perform
' analysis to find threshold current value and location.

'***CEC code below***
'Call transmit("UNT UNL MLA TALK" + Str$(intKth2500), intStatus)   ' Address 2500 to talk
'If (intStatus And 8) Then Stop                                      ' Check for timeout
'Call IErarray(byteArray!(1), 2, length, status)                     ' Read "#0" from binary string
'If (intStatus And 8) Then Stop                                      ' Check for timeout
'Call IErarray(byteArray!(1), 2 * intSteps * 4 + 1, length, status)    ' Enter rdgs from both channels
'If (intStatus And 8) Then Stop                                      ' Check for timeout
'If length& < intSteps * 4 Then Stop                                 ' Verify length of string
'Call transmit("UNT UNL", intStatus)                                 ' Stop talking
'If (intStatus And 8) Then Stop                                      ' Check for timeout
'***CEC code above***

'NI code below
Call ReceiveSetup(intGPIB, intKth2500)                         'Set up 2500 to talk, GPIB board is listening
If (status > 16383) Then Stop                                  'Check for timeout(=16384)Call transmit("UNT UNL MLA TALK" + Str$(intKth2500), intStatus)   ' Address 2500 to talk
Call RcvRespMsg32(intGPIB, byteArray(1), 2, STOPend)           'Read first (#0) reading, throw away
If (status > 16383) Then Stop                                  'Check for timeout(=16384)
Call RcvRespMsg32(intGPIB, byteArray(1), 2 * intSteps * 4 + 1, STOPend) 'receive readings from 2420, automatically grabbing all data, ibcntl for # of bytes
If (status > 16383) Then Stop                                  'Check for timeout(=16384)
If ibcntl < 2 * intSteps * 4 Then Stop                           ' Verify length of string using global ibcntl, 2 arrays (V, I), 4 8-bit bytes each reading
Call SendIFC(intGPIB)                                             'stop talking by sending InterFaceClear (IFC) command
If (status > 16383) Then Stop                                  'Check for timeout(=16384)

        
dblMaxima = 0                                                       'clear Maxima
For intPointer = 1 To intSteps                                      'loop once for each sweep step
    dblArray(intPDCurrent, intPointer) = 2000 * byteArray(intPointer * 2 - 1) 'pass channel 1 (front facet) to dblArray() (scale to fit graph)
    dblArray(intBSDCurrent, intPointer) = 1000 * byteArray(intPointer * 2) 'pass channel 2 (back facet) to dblArray() (scale to fit graph)
    If intPointer <> 1 Then                                         'if not the first point, calculate Ld/Id
        dblArray(int1stDofPDC, intPointer) = 40 * (dblArray(intPDCurrent, intPointer) - dblArray(intPDCurrent, intPointer - 1))
    End If                                                          'and record value in dblArray()
    If intPointer > 2 Then                                          'if beyond second point calculate Ld2/I2d
        dblArray(int2ndDofPDC, intPointer) = 40 * (0.05 * dblArray(int1stDofPDC, intPointer) - 0.05 * dblArray(int1stDofPDC, intPointer - 1))
        If dblArray(int2ndDofPDC, intPointer) > dblMaxima Then      'look for first maxima
            dblMaxima = dblArray(int2ndDofPDC, intPointer)          'record current at maxima
            intMaxPoint = intPointer                                'record location of maxima
        End If
    End If
Next intPointer
textThresoldCurrent = Int(1000 * dblArray(intLDCurrent, intMaxPoint)) / 1000   'display the current threshold)/1000

DoEvents                                                            'update display




'Find the Mean, Stddev, Maxima, and Minima of the d2L/dI2:

dblSum = 0              'clear variables
dblMaxima = 0
dblMinima = 0

For intPointer = (intMaxPoint + 3) To intSteps - 1                'loop thru values of d2L/dI2
                                                                  'after beyond threshold current
    If dblArray(int2ndDofPDC, intPointer) > dblMaxima Then        'Find Maxima
        dblMaxima = dblArray(int2ndDofPDC, intPointer)
        intMaxPoint = intPointer
    End If
    
    If dblArray(int2ndDofPDC, intPointer) < dblMinima Then        'Find Minima
        dblMinima = dblArray(int2ndDofPDC, intPointer)
        intMinPoint = intPointer
    End If
    
    dblSum = dblSum + dblArray(int2ndDofPDC, intPointer)          'sum all the points (used for mean)
Next intPointer

If Abs(intSteps - intMaxPoint) = 0 Then
    dblMean = 999
Else
    dblMean = dblSum / (intSteps - intMaxPoint)                       'calculate mean from sum
End If

dblSum = 0
For intPointer = (intMaxPoint + 3) To intSteps                    'loop thru values again!
    dblSum = dblSum + (dblArray(int2ndDofPDC, intPointer) - dblMean) ^ 2  'calculate sum of differences
Next intPointer

If Abs(intSteps - intMaxPoint) = 0 Then
    dblStddev = 999
Else
    dblStddev = Sqr(dblSum / (intSteps - intMaxPoint))                'calculate Standard Deviation
End If

textKinkMaxima.Text = Int(1000 * dblArray(int2ndDofPDC, intMaxPoint)) / 1000    'display maxima

If intMinPoint <> 0 Then
    textKinkMinima.Text = Int(1000 * dblArray(int2ndDofPDC, intMinPoint)) / 1000    'display minima
Else
    textKinkMinima.Text = ""
End If

textKinkStddev.Text = Int(1000 * dblStddev) / 1000                              'display Stddev
DoEvents                                                                        'update display



'If the Pass/Fail test is enabled, compare values and set flag:

If EnableTest = True Then                             'if test is enabled
    If (dblMinima + 1.5 * dblStddev) < 0 Then         'if minima is less than -3*sigma => set fail
        textPassFail = "Fail"
        textPassFail.ForeColor = &H8000000A
        textPassFail.BackColor = &HFF&
    ElseIf (dblMaxima - 3 * dblStddev) > 0 Then       'if maxima is more than 3*sigma => set fail
        textPassFail = "Fail"
        textPassFail.ForeColor = &H8000000A
        textPassFail.BackColor = &HFF&
    Else                                              'else set pass
        textPassFail = "Pass"
        textPassFail.ForeColor = &H8000&
        textPassFail.BackColor = &HFF00&
    End If
End If                                              'if test is disabled
EnableTest = False                                  'disable test (default)
DoEvents                                            'update display



    
Open "c:\data.csv" For Output As #1
For intPointer = 1 To intSteps
    strData = dblArray(intLDVoltage, intPointer) & ","
    strData = strData & dblArray(intLDCurrent, intPointer) & ","
    strData = strData & dblArray(intPDCurrent, intPointer) / 2000 & ","  ' divide by scaling factor to save raw data
    strData = strData & dblArray(intBSDCurrent, intPointer) / 1000
    Print #1, strData
Next intPointer
Close #1

'Calculate total test and analysis time and display

DoEvents                                                        'update display

End Sub

'******************************************************************
'buttonRunTest_Click:

'The sweep has been triggered by the operator.  This sub initializes
'variable, checks input parameters, resets and programs the
'the instruments, triggers the sweep, collects the data, and analyzes
'the data for statitics and Pass/Fail condition (if enabled.)

'******************************************************************
Private Sub buttonRunTest_Click()

Dim intPointer As Integer

Form_Load                   'init variables, etc
Check_Sweep_Parameters      'check input paramters
ResetInstruments            'reset all instruments
Setup2500                 'setup PD meter
Setup2420                   'setup current sweep
ExecuteSweep                'trigger sweep and analyze data
ChartData                   'output results to the chart object
Open "c:\temp.dat" For Output As 1
For intPointer = 1 To intSteps
    Write #1, CStr(dblArray(int2ndDofPDC, intPointer))
Next intPointer
Close #1
End Sub

'******************************************************************
'ChartData:

'Update the chart object with latest data.

'******************************************************************
Private Sub ChartData()

MSChart1.ColumnCount = intSteps     'scale x axis of chart
MSChart1.ChartData = dblArray       'enter lastest data points
MSChart1.ColumnCount = intSteps     'correct for stray points in
                                    'dblArray()

Label_Chart                         're label legend

DoEvents    'update display

End Sub

'******************************************************************
'comboTempOnOff_Change:

'Setup 2510 to using input from combo boxes to control temp. of module

'******************************************************************
Private Sub comboTempOnOff_Click()
Dim int2510Array(1) As Integer          'setup array for ResetSysing of the 2510
int2510Array(0) = intKth2510            'Load 2510 GPIB address
int2510Array(1) = NOADDR                'NI requires that address list end with NOADDR
strData = Space(100)                    'Define max length of string, req for NI code

If comboTempOnOff.Text = "ON" Then
    
'***CEC code below***
'    Call send(intKth2510, "*rst", intStatus)
'    Call send(intKth2510, ":sens:curr:prot:lev 1.0", intStatus)
'    Call send(intKth2510, ":sens:temp:tran ther", intStatus)
'    Call send(intKth2510, ":sens:temp:curr:auto on", intStatus)
'    Call send(intKth2510, ":sens:temp:ther:range 1e4", intStatus)
'    Call send(intKth2510, ":sour:temp:spo " & comboTempSetPoint.Text, intStatus)
'    Call send(intKth2510, ":outp on", intStatus)
'    Call send(intKth2510, ":meas:res:ac?", intStatus)
'    Call enter(strData, 100, intLength, intKth2510, intStatus)
'    txtTECRes.Text = strData
'    Call send(intKth2510, ":outp on", intStatus)
'***CEC code above***

'NI code below
    Call ResetSys(intGPIB, int2510Array())        'Reset 2510
    Call Send(intGPIB, intKth2510, ":sens:curr:prot:lev 1.0", NLend)
    Call Send(intGPIB, intKth2510, ":sens:temp:tran ther", NLend)
    Call Send(intGPIB, intKth2510, ":sens:temp:curr:auto on", NLend)
    Call Send(intGPIB, intKth2510, ":sens:temp:ther:range 1e4", NLend)
    Call Send(intGPIB, intKth2510, ":sour:temp:spo " & comboTempSetPoint.Text, NLend)
    Call Send(intGPIB, intKth2510, ":outp on", NLend)
    Call Send(intGPIB, intKth2510, ":meas:res:ac?", NLend)  'Measure ohms using AC method, this turns off TEC control
    Call Receive(intGPIB, intKth2510, strData, STOPend)
    strData = Left(strData, 4)                 'Keep only 3 digits (plus decimal point), AC resistance spec is 0.1% of reading
    txtTECRes.Text = strData                   'Display resistance value on form
    Call Send(intGPIB, intKth2510, ":outp on", NLend)       'Turn TEC control ON, was turned off by AC ohms meas


Else
'***CEC code below***
'    Call send(intKth2510, "*rst", intStatus)
'NI code below
'    Call Send(intGPIB, intKth2510, "*rst", NLend)
    Call ResetSys(intGPIB, int2510Array())
End If

End Sub

Private Sub comboTempSetPoint_Click()

'***CEC code below***
'    Call send(intKth2510, ":sour:temp:spo " & comboTempSetPoint.Text, intStatus)
'NI code below
    Call Send(intGPIB, intKth2510, ":sour:temp:spo " & comboTempSetPoint.Text, NLend)

End Sub

'******************************************************************
'Form_Load:

'Perform initializations of variables and display objects.

'******************************************************************
Private Sub Form_Load()
Dim intPointer As Integer

'Clear the data array before updating the chart so that default
'psuedo noise is cleared from the chart display.

For intPointer = 1 To 1000
    dblArray(intLDVoltage, intPointer) = 0
    dblArray(intLDCurrent, intPointer) = 0
    dblArray(intBSDCurrent, intPointer) = 0
    dblArray(intPDCurrent, intPointer) = 0
    dblArray(int2ndDofPDC, intPointer) = 0
    dblArray(int1stDofPDC, intPointer) = 0
Next intPointer

MSChart1.ChartData = dblArray   'Feed chart with zeros

Label_Chart                     'fix legend



'Show system ready message...

textTime.ForeColor = &HC000&
textTime.Text = "System Ready"



'Hide Pass/Fail message by making foreground and background
'match form background color.

textPassFail = ""
textPassFail.ForeColor = &H8000000A
textPassFail.BackColor = &H8000000B



'Clear the test statistics displays

textThresoldCurrent = ""
textKinkMaxima = ""
textKinkMinima = ""
textKinkStddev = ""


'Format Chart attributes
'Increase line width of each series
MSChart1.Plot.SeriesCollection(intLDVoltage).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intLDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intPDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(intBSDCurrent).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(int2ndDofPDC).Pen.Width = 25   'change line width
MSChart1.Plot.SeriesCollection(int1stDofPDC).Pen.Width = 25   'change line width

'Change background of chart to white (default= formbackground (=grey))
MSChart1.Backdrop.Fill.Style = VtFillStyleBrush
MSChart1.Backdrop.Fill.Brush.Style = VtBrushStyleSolid
MSChart1.Backdrop.Fill.Brush.FillColor.Set 255, 255, 255

DoEvents        'update display

End Sub

'******************************************************************
'Label_Chart:

'This sub puts the correct labels in the legend of the chart.

'******************************************************************
Private Sub Label_Chart()

MSChart1.Row = 1                    'address row
MSChart1.RowLabel = "LD Voltage"    'caption row
MSChart1.Row = 2
MSChart1.RowLabel = "LD Current"
MSChart1.Row = 3
MSChart1.RowLabel = "Back Facet Current"
MSChart1.Row = 4
MSChart1.RowLabel = "Front PD Current"
MSChart1.Row = 5
MSChart1.RowLabel = "(dL)2/d(I2)"
MSChart1.Row = 6
MSChart1.RowLabel = "dL/dI"

DoEvents    'update display

End Sub

'******************************************************************
'Check_Sweep_Parameters:

'This code examines the sweep input parameters and adjust those that
'will cause conflicts in the instruments or in the program.  This
'program assumes that all current sweeps will be from lower values of
'current to higher values of current.

'******************************************************************
Private Sub Check_Sweep_Parameters()



'Confine dblSourceDelay to between 0 and 20mS.  Negative source delays
'will cause the 2420 to generate an error during programming.  Delays
'in excess of 20mS are not needed because the total capacitance of
'the cabling and laser diode will be less than a few hundred pico Farads.

dblSourceDelay = Val(txtSourceDelay)
If dblSourceDelay < 0 Then dblSourceDelay = 0
If dblSourceDelay > 0.02 Then dblSourceDelay = 0.02
txtSourceDelay.Text = dblSourceDelay



'The starting values or lowest value in the sweep must be greater than
'zero to prevent a negative going voltage spike from damaging the
'laser diode.  (In an effort to maximize input bandwidth of the laser
'diode the capacitance must kept to a minimum.  For this reason, no
'clamping diode is used to prevent negative going voltages from causing
'damage.)  Also, the routine that analyzes the laser diode must be able
'to detect the threshold current to be able to correctly analyze the
'kinks.  For this reason, if the pass/fail test is enabled, the starting
'current sweep value must be much less than the current threshold of
'about 10mA.

dblStartCurrent = Val(textStartCurrent)
If dblStartCurrent < 0.0001 Then dblStartCurrent = 0.0001
If dblStartCurrent > 0.25 Then dblStartCurrent = 0.25
If EnableTest = True Then dblStartCurrent = 0.001
textStartCurrent.Text = dblStartCurrent



'The final current value of the sweep is limited in this program to
'300mA.  This value can be increased up to the limitations of the 2420
'or 3A.  Here the value is limited to protect the specific model of
'laser diode that is being tested.  Also, the final current values is
'adjusted to ensure that the sweep if from lower values to higher
'values.  This supports the dL/dI algorithms, etc.

dblStopCurrent = Val(textStopCurrent)
'If (dblStopCurrent - dblStartCurrent) < 0.01 Then dblStopCurrent = dblStartCurrent + 0.01
If dblStopCurrent > 1# Then dblStopCurrent = 1#
textStopCurrent.Text = dblStopCurrent




'Here the value of the step size is checked.  To support dL/dI algorithm,
'the step is adjusted to provide at least 10 steps in the sweep.

dblStepCurrent = Val(textStepCurrent)
If dblStepCurrent > ((dblStopCurrent - dblStartCurrent) / 10) Then dblStepCurrent = (dblStopCurrent - dblStartCurrent) / 10
textStepCurrent = dblStepCurrent



'Here the number of steps in the sweep is calculated given start, stop,
'and step current values.  If the number of steps exceed 1000, then the
'number of steps is clamped to 1000 and the current step value is
'calculated to based on (stop-start)/1000.

intSteps = Int(1.01 + (dblStopCurrent - dblStartCurrent) / dblStepCurrent)
If intSteps > 1000 Then
    intSteps = 1000
    dblStepCurrent = (dblStopCurrent - dblStartCurrent) / 1000
    textStepCurrent = dblStepCurrent
End If
textSteps.Text = intSteps

DoEvents    'update display

End Sub
Private Sub mnuExit_Click()
    Unload frmLIVDemo
End Sub

Public Sub Form_Unload(Cancel As Integer)
    Cancel = MsgBox("Exit?", 20, "Exit Verify")         'Confirm exit
'    If Cancel = 6 Then
'        Quit = True
'    Else
'        Quit = False
'    End If
If Cancel = 6 Then              'Quit application was chosen, close all potentially open forms
    
    End                         'Stop program execution
End If

End Sub


Private Sub mnuSaveAs_Click()
    Dim i As Integer
    Dim str24xxIRange As String
    Dim str24xxVRange As String
      
    ' Set CancelError is True
    CommonDialog1.CancelError = True
    On Error GoTo ErrHandler
    ' Set flags
    CommonDialog1.Flags = cdlOFNHideReadOnly
    ' Set filters
    CommonDialog1.Filter = "CSV Files (*.CSV)|*.csv"
    ' Specify default filter
    CommonDialog1.FilterIndex = 1
    ' Display the Open dialog box
    CommonDialog1.ShowSave
    ' Display name of selected file
  
    Call Send(intGPIB, intKth2420%, ":sour:curr:rang?", NLend)
    str24xxIRange = Val(EnterIB(intKth2420%))
    
    Call Send(intGPIB, intKth2420%, ":sens:volt:rang?", NLend)
    str24xxVRange = Val(EnterIB(intKth2420%))
  
    Open CommonDialog1.filename For Output As #1
    Print #1, Date, ",", Time
 '   Print #1, txtComments
    Print #1, "24xx settings:"
    Print #1, "NPLC = ,", frmLIVDemo.comboNPLC, ",Src Delay = ,", CSng(frmLIVDemo.txtSourceDelay)
    Print #1, "Start I = ,", CSng(frmLIVDemo.textStartCurrent), ",Step I = ,", CSng(frmLIVDemo.textStepCurrent), ",Stop I = ,", CSng(frmLIVDemo.textStopCurrent)
    Print #1, "I Range = ,", str24xxIRange, ",V Range = ,", str24xxVRange
    
    Print #1, "2500 settings:"
    Print #1, "NPLC = ,", frmLIVDemo.comboNPLC
    Print #1, "Ch1 I Range = ,", CSng(frmLIVDemo.textN1CurrRange), ",Ch1 V Bias = ,", CSng(frmLIVDemo.textN1Bias), ", Ch1 I Range = ,", CSng(frmLIVDemo.textN1CurrRange)
    Print #1, "Ch2 I Range = ,", CSng(frmLIVDemo.textN2CurrRange), ",Ch2 V Bias = ,", CSng(frmLIVDemo.textN2Bias), ", Ch2 I Range = ,", CSng(frmLIVDemo.textN2CurrRange)
    
    Print #1,
    Print #1, "LD Curr,LD Volt, PD1 Curr, PD2 Curr, PD1 deriv, PD2 deriv"
    
    For i = 1 To intSteps
        strData = dblArray(intLDCurrent, i) & ","
        strData = strData & dblArray(intLDVoltage, i) & ","
        strData = strData & dblArray(intPDCurrent, i) / 2000 & ","
        strData = strData & dblArray(intBSDCurrent, i) / 1000 & ","
        If i > 1 Then
            strData = strData & (dblArray(intPDCurrent, i) - dblArray(intPDCurrent, i - 1)) / (1000 * CSng(frmLIVDemo.textStepCurrent)) & ","
            strData = strData & (dblArray(intBSDCurrent, i) - dblArray(intBSDCurrent, i - 1)) / (4000000 * CSng(frmLIVDemo.textStepCurrent))
        Else
            strData = strData & 0 & ","
            strData = strData & 0
        End If
        Print #1, strData
    Next i
    Close #1
  Exit Sub
  
ErrHandler:
    'User pressed the Cancel button
End Sub



Function EnterIB(AdrCV As Integer) As String
    Dim temp As String
    Dim length As Integer
    Dim status As Integer
    temp = Space(32)
    
    Call Receive(intGPIB, AdrCV, temp, STOPend)
    If status <> 0 Then Stop
    'EnterIB = Left$(temp, length)
    EnterIB = temp
End Function


